/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka;

import com.freescale.s32ds.debug.ka.IOSContributor;
import com.freescale.s32ds.debug.ka.KAPluginActivator;
import com.freescale.s32ds.debug.ka.Messages;
import com.nxp.s32ds.ext.ide.ui.dialogs.FilteringElementTreeSelectionDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.widgets.CompositeFactory;
import org.eclipse.jface.widgets.TextFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class OSAwarenessLaunchTab
extends AbstractLaunchConfigurationTab
implements ILaunchConfigurationTab,
SelectionListener {
    private Composite control = null;
    private Combo combo = null;
    private List<IOSContributor> contributors = null;
    private Composite osekOrtiFileComposite = null;
    private Text fileInput;
    private String filePath = "";
    private static final String EMPTY_STRING = "";
    private static final String ORT_FILE_EXTENSION = ".ort";
    private static final String ORT_FILE_EXTENSION_MATCH = "*.ort";
    private static final String ALL_FILES_EXTENSION = "*.*";
    private static final String WORKSPACE_VAR = "workspace_loc";
    private static final String OSEK_PLUGIN_EXTENSION = "com.freescale.debug.ka.osek.sysbrowser";
    private static final String PROJECT_ATTRIBUT = "org.eclipse.cdt.launch.PROJECT_ATTR";

    public void createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.control.setLayout((Layout)layout);
        this.control.setLayoutData((Object)data);
        new Composite(this.control, 0){
            {
                this.setLayout((Layout)new GridLayout(2, true));
                new Label((Composite)this, 0).setText(Messages.OSAwareness_OS);
                OSAwarenessLaunchTab.this.combo = new Combo((Composite)this, 8);
                OSAwarenessLaunchTab.this.combo.addSelectionListener((SelectionListener)OSAwarenessLaunchTab.this);
            }
        };
    }

    public Control getControl() {
        return this.control;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("com.freescale.s32ds.debug.ka.osplugin", null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.contributors = KAPluginActivator.getDefault().getOSContributors();
        int[] selection = new int[1];
        this.combo.setItems(new ArrayList<String>(configuration, selection){
            {
                this.add(OSAwarenessLaunchTab.EMPTY_STRING);
                for (IOSContributor contributor : OSAwarenessLaunchTab.this.contributors) {
                    this.add(contributor.getName());
                    try {
                        if (contributor.getID().equals(iLaunchConfiguration.getAttribute("com.freescale.s32ds.debug.ka.osplugin", null))) {
                            nArray[0] = this.size() - 1;
                        }
                        OSAwarenessLaunchTab.this.filePath = iLaunchConfiguration.getAttribute("com.freescale.s32ds.debug.ka.osplugin.ortifile", OSAwarenessLaunchTab.this.getOrtiFileName(iLaunchConfiguration));
                    }
                    catch (CoreException e) {
                        KAPluginActivator.log(e);
                    }
                }
            }
        }.toArray(new String[0]));
        this.combo.select(selection[0]);
        this.combo.notifyListeners(13, new Event());
        if (this.combo.getItemCount() == 1) {
            this.combo.setItem(0, Messages.OSAwareness_Not_available);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.combo.getSelectionIndex() == 0) {
            configuration.setAttribute("com.freescale.s32ds.debug.ka.osplugin", null);
        } else {
            configuration.setAttribute("com.freescale.s32ds.debug.ka.osplugin", this.contributors.get(this.combo.getSelectionIndex() - 1).getID());
            if (this.contributors.get(this.combo.getSelectionIndex() - 1).getID().equals(OSEK_PLUGIN_EXTENSION)) {
                String path = this.fileInput.getText();
                try {
                    path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(path);
                }
                catch (CoreException e) {
                    KAPluginActivator.log(e);
                    return;
                }
                configuration.setAttribute("com.freescale.s32ds.debug.ka.osplugin.ortifile", path);
            }
        }
    }

    public String getName() {
        return Messages.OSAwareness;
    }

    public Image getImage() {
        return KAPluginActivator.getDefault().getOsTabIcon();
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Combo) {
            Combo combo = (Combo)e.getSource();
            int index = combo.getSelectionIndex() - 1;
            if (index >= 0 && this.contributors.size() > index && this.contributors.get(index).getID().equals(OSEK_PLUGIN_EXTENSION)) {
                if (this.osekOrtiFileComposite == null || this.osekOrtiFileComposite.isDisposed()) {
                    GridData data = new GridData();
                    data.horizontalAlignment = 4;
                    data.grabExcessHorizontalSpace = true;
                    this.osekOrtiFileComposite = (Composite)((CompositeFactory)((CompositeFactory)WidgetFactory.composite((int)0).layout((Layout)new GridLayout(4, false))).layoutData((Object)data)).create((Widget)this.control);
                    WidgetFactory.label((int)0).text(Messages.OSAwareness_ORT_File).create((Widget)this.osekOrtiFileComposite);
                    this.fileInput = (Text)((TextFactory)WidgetFactory.text((int)2048).layoutData((Object)data)).create((Widget)this.osekOrtiFileComposite);
                    this.fileInput.setText(this.filePath);
                    final Text text = this.fileInput;
                    text.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent arg0) {
                            OSAwarenessLaunchTab.this.updateLaunchConfigurationDialog();
                        }
                    });
                    Button workspaceButton = (Button)WidgetFactory.button((int)8).text(Messages.OSAwareness_ORT_Workspace_button).create((Widget)this.osekOrtiFileComposite);
                    workspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            OSAwarenessLaunchTab.this.handleBrowseWorkspaceButton(Messages.OSAwareness_ORT_Select_ORT_file, text);
                        }
                    });
                    Button fileSystemButton = (Button)WidgetFactory.button((int)8).text(Messages.OSAwareness_ORT_File_system_button).create((Widget)this.osekOrtiFileComposite);
                    fileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            OSAwarenessLaunchTab.this.handleBrowseFileSystemButton(Messages.OSAwareness_ORT_Select_ORT_file, text);
                        }
                    });
                    this.control.layout(true);
                }
            } else if (this.osekOrtiFileComposite != null && !this.osekOrtiFileComposite.isDisposed()) {
                this.osekOrtiFileComposite.dispose();
                this.control.layout(true);
            }
        }
        this.updateLaunchConfigurationDialog();
    }

    private String handleBrowseFileSystemButton(String title, Text text) {
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
        dialog.setFilterExtensions(new String[]{ORT_FILE_EXTENSION_MATCH, ALL_FILES_EXTENSION});
        dialog.setText(title);
        String path = dialog.open();
        if (path != null) {
            text.setText(path);
        }
        return Objects.requireNonNull(path, EMPTY_STRING);
    }

    private String handleBrowseWorkspaceButton(String title, Text text) {
        FilteringElementTreeSelectionDialog dialog = new FilteringElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(title);
        dialog.setMessage(EMPTY_STRING);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        String fileLoc = null;
        if (dialog.open() == 0) {
            IResource resource = (IResource)dialog.getFirstResult();
            String arg = resource.getFullPath().toOSString();
            fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression(WORKSPACE_VAR, arg);
            text.setText(fileLoc);
        }
        return Objects.requireNonNull(fileLoc, EMPTY_STRING);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setWarningMessage(null);
        if (this.fileInput != null && !this.fileInput.isDisposed()) {
            String path = this.fileInput.getText();
            try {
                path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(path);
            }
            catch (CoreException e) {
                KAPluginActivator.log(e);
                this.setErrorMessage(Messages.OSAwareness_ORT_Something_went_wrong);
                return false;
            }
            if (path.isEmpty()) {
                this.setErrorMessage(Messages.OSAwareness_ORT_File_input_can_not_be_empty);
                return false;
            }
            File file = new File(path);
            if (!file.exists()) {
                this.setErrorMessage(String.format(Messages.OSAwareness_ORT_File_does_not_exist, this.fileInput.getText()));
                return false;
            }
            if (!path.endsWith(ORT_FILE_EXTENSION)) {
                this.setErrorMessage(String.format(Messages.OSAwareness_ORT_File_is_not_a_valid_file, this.fileInput.getText()));
                return false;
            }
            if (file.length() == 0L) {
                this.setErrorMessage(String.format(Messages.OSAwareness_ORT_File_is_empty, this.fileInput.getText()));
                return false;
            }
        }
        return true;
    }

    private String getOrtiFileName(ILaunchConfiguration lConfig) {
        String projectName = EMPTY_STRING;
        try {
            projectName = lConfig.getAttribute(PROJECT_ATTRIBUT, EMPTY_STRING);
        }
        catch (CoreException e) {
            KAPluginActivator.log(e);
            return EMPTY_STRING;
        }
        if (projectName.equals(EMPTY_STRING)) {
            return EMPTY_STRING;
        }
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            return String.valueOf(project.getLocation().toString()) + '/' + projectName + ORT_FILE_EXTENSION;
        }
        catch (NullPointerException exception) {
            KAPluginActivator.log(exception);
            return EMPTY_STRING;
        }
    }
}

