/* Copyright 2019-2023 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 ****************************************************************************/
	.arch	armv8-a

	.text
	.align 2
_init_vectors:
#ifdef __ILP32__
	adrp	x1, :pg_hi21:__EL3_Vectors
	add		x1, x1, :lo12:__EL3_Vectors
	msr		vbar_el3, x1
	adrp	x1, :pg_hi21:__EL2_Vectors
	add		x1, x1, :lo12:__EL2_Vectors
	msr		vbar_el2, x1
	adrp	x1, :pg_hi21:__EL1_Vectors
	add		x1, x1, :lo12:__EL1_Vectors
	msr		vbar_el1, x1
#else
	ldr		x1, =__EL3_Vectors
	msr		vbar_el3, x1
	ldr		x1, =__EL2_Vectors
	msr		vbar_el2, x1
	ldr		x1, =__EL1_Vectors
	msr		vbar_el1, x1
#endif
	ret

	.text
	.align 2
_flat_map:
	/* Page table setup (identity mapping).  */
	adrp	x0, ttb
	add		x0, x0, :lo12:ttb
	msr		ttbr0_el3, x0
	adr		x1, .				/* phys address */
	bic		x1, x1, #(1 << 30) - 1		/* 1GB block alignment */
	add		x2, x0, x1, lsr #(30 - 3)	/* offset in level 1 page
						   table */
	mov		x3, #0x401			/* page table attributes
						   (AF, block) */
	orr		x1, x1, x3
	mov		x3, #(1 << 30)			/* 1GB block */
	str		x1, [x2], #8			/* 1st GB */
	add		x1, x1, x3
	str		x1, [x2]			/* 2nd GB */

	/* Setup/enable the MMU.  */

	/* RES1, RES1, 40-bit PA, 39-bit VA, inner/outer cacheable WB */
	ldr		x0, =(1 << 31) | (1 << 23) | (2 << 16) | 25 | (3 << 10) | (3 << 8)
	msr		tcr_el3, x0

	mov		x0, #0xee			/* Inner/outer cacheable WB */
	msr		mair_el3, x0
	isb

	mrs		x0, sctlr_el3
	ldr		x1, =0x100d			/* bits I(12) SA(3) C(2) M(0) */
	bic		x0, x0, #(1 << 1)		/* clear bit A(1) */
	bic		x0, x0, #(1 << 19)		/* clear WXN */
	orr		x0, x0, x1			/* set bits */

	dsb		sy
	msr		sctlr_el3, x0
	isb
	ret

	.data
	.align	12
ttb:
	.space	4096, 0

	.text
	.align	2
	.globl	_cpu_init_hook
	.type	_cpu_init_hook, %function
_cpu_init_hook:
	stp		x29, x30, [sp, #-16]!
	mov		x29, sp
	bl		_init_vectors
	bl		_flat_map
	ldp		x29, x30, [sp], #16
	ret

	.pool
	.size	_cpu_init_hook, . - _cpu_init_hook
