/* Copyright 2019-2023 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 ****************************************************************************/
	.arch	armv8-a

	.section .vectors
	.align	12
	.globl	__Vectors
__Vectors:

	.macro	ventry	label
	.align	7
	b	\label
	.endm

	.globl	__EL3_Vectors
__EL3_Vectors:
	ventry	Current_EL3_SP0_Sync_Handler
	ventry	Current_EL3_SP0_IRQ_Handler
	ventry	Current_EL3_SP0_FIQ_Handler
	ventry	Current_EL3_SP0_SError_Handler

	ventry	Current_EL3_SPx_Sync_Handler
	ventry	Current_EL3_SPx_IRQ_Handler
	ventry	Current_EL3_SPx_FIQ_Handler
	ventry	Current_EL3_SPx_SError_Handler

	ventry	Lower_EL3_AArch64_Sync_Handler
	ventry	Lower_EL3_AArch64_IRQ_Handler
	ventry	Lower_EL3_AArch64_FIQ_Handler
	ventry	Lower_EL3_AArch64_SError_Handler

	ventry	Lower_EL3_AArch32_Sync_Handler
	ventry	Lower_EL3_AArch32_IRQ_Handler
	ventry	Lower_EL3_AArch32_FIQ_Handler
	ventry	Lower_EL3_AArch32_SError_Handler

	.globl	__EL2_Vectors
__EL2_Vectors:
	ventry	Current_EL2_SP0_Sync_Handler
	ventry	Current_EL2_SP0_IRQ_Handler
	ventry	Current_EL2_SP0_FIQ_Handler
	ventry	Current_EL2_SP0_SError_Handler

	ventry	Current_EL2_SPx_Sync_Handler
	ventry	Current_EL2_SPx_IRQ_Handler
	ventry	Current_EL2_SPx_FIQ_Handler
	ventry	Current_EL2_SPx_SError_Handler

	ventry	Lower_EL2_AArch64_Sync_Handler
	ventry	Lower_EL2_AArch64_IRQ_Handler
	ventry	Lower_EL2_AArch64_FIQ_Handler
	ventry	Lower_EL2_AArch64_SError_Handler

	ventry	Lower_EL2_AArch32_Sync_Handler
	ventry	Lower_EL2_AArch32_IRQ_Handler
	ventry	Lower_EL2_AArch32_FIQ_Handler
	ventry	Lower_EL2_AArch32_SError_Handler

	.globl	__EL1_Vectors
__EL1_Vectors:
	ventry	Current_EL1_SP0_Sync_Handler
	ventry	Current_EL1_SP0_IRQ_Handler
	ventry	Current_EL1_SP0_FIQ_Handler
	ventry	Current_EL1_SP0_SError_Handler

	ventry	Current_EL1_SPx_Sync_Handler
	ventry	Current_EL1_SPx_IRQ_Handler
	ventry	Current_EL1_SPx_FIQ_Handler
	ventry	Current_EL1_SPx_SError_Handler

	ventry	Lower_EL1_AArch64_Sync_Handler
	ventry	Lower_EL1_AArch64_IRQ_Handler
	ventry	Lower_EL1_AArch64_FIQ_Handler
	ventry	Lower_EL1_AArch64_SError_Handler

	ventry	Lower_EL1_AArch32_Sync_Handler
	ventry	Lower_EL1_AArch32_IRQ_Handler
	ventry	Lower_EL1_AArch32_FIQ_Handler
	ventry	Lower_EL1_AArch32_SError_Handler

	.size	__Vectors, . - __Vectors

	.align	2
	.weak	Default_Handler
	.type	Default_Handler, %function
Default_Handler:
	b	.
	.pool
	.size	Default_Handler, . - Default_Handler

/*    Macro to define default handlers. Default handler
 *    will be weak symbol and just dead loops. They can be
 *    overwritten by other handlers */
	.macro	def_irq_handler	handler_name
	.weak	\handler_name
	.set	\handler_name, Default_Handler
	.endm

	def_irq_handler	Current_EL3_SP0_Sync_Handler
	def_irq_handler	Current_EL3_SP0_IRQ_Handler
	def_irq_handler	Current_EL3_SP0_FIQ_Handler
	def_irq_handler	Current_EL3_SP0_SError_Handler

	def_irq_handler	Current_EL3_SPx_Sync_Handler
	def_irq_handler	Current_EL3_SPx_IRQ_Handler
	def_irq_handler	Current_EL3_SPx_FIQ_Handler
	def_irq_handler	Current_EL3_SPx_SError_Handler

	def_irq_handler	Lower_EL3_AArch64_Sync_Handler
	def_irq_handler	Lower_EL3_AArch64_IRQ_Handler
	def_irq_handler	Lower_EL3_AArch64_FIQ_Handler
	def_irq_handler	Lower_EL3_AArch64_SError_Handler

	def_irq_handler	Lower_EL3_AArch32_Sync_Handler
	def_irq_handler	Lower_EL3_AArch32_IRQ_Handler
	def_irq_handler	Lower_EL3_AArch32_FIQ_Handler
	def_irq_handler	Lower_EL3_AArch32_SError_Handler

	def_irq_handler	Current_EL2_SP0_Sync_Handler
	def_irq_handler	Current_EL2_SP0_IRQ_Handler
	def_irq_handler	Current_EL2_SP0_FIQ_Handler
	def_irq_handler	Current_EL2_SP0_SError_Handler

	def_irq_handler	Current_EL2_SPx_Sync_Handler
	def_irq_handler	Current_EL2_SPx_IRQ_Handler
	def_irq_handler	Current_EL2_SPx_FIQ_Handler
	def_irq_handler	Current_EL2_SPx_SError_Handler

	def_irq_handler	Lower_EL2_AArch64_Sync_Handler
	def_irq_handler	Lower_EL2_AArch64_IRQ_Handler
	def_irq_handler	Lower_EL2_AArch64_FIQ_Handler
	def_irq_handler	Lower_EL2_AArch64_SError_Handler

	def_irq_handler	Lower_EL2_AArch32_Sync_Handler
	def_irq_handler	Lower_EL2_AArch32_IRQ_Handler
	def_irq_handler	Lower_EL2_AArch32_FIQ_Handler
	def_irq_handler	Lower_EL2_AArch32_SError_Handler

	def_irq_handler	Current_EL1_SP0_Sync_Handler
	def_irq_handler	Current_EL1_SP0_IRQ_Handler
	def_irq_handler	Current_EL1_SP0_FIQ_Handler
	def_irq_handler	Current_EL1_SP0_SError_Handler

	def_irq_handler	Current_EL1_SPx_Sync_Handler
	def_irq_handler	Current_EL1_SPx_IRQ_Handler
	def_irq_handler	Current_EL1_SPx_FIQ_Handler
	def_irq_handler	Current_EL1_SPx_SError_Handler

	def_irq_handler	Lower_EL1_AArch64_Sync_Handler
	def_irq_handler	Lower_EL1_AArch64_IRQ_Handler
	def_irq_handler	Lower_EL1_AArch64_FIQ_Handler
	def_irq_handler	Lower_EL1_AArch64_SError_Handler

	def_irq_handler	Lower_EL1_AArch32_Sync_Handler
	def_irq_handler	Lower_EL1_AArch32_IRQ_Handler
	def_irq_handler	Lower_EL1_AArch32_FIQ_Handler
	def_irq_handler	Lower_EL1_AArch32_SError_Handler

	.end
