/*******************************************************************************
 * Copyright (c) 2001, 2006 IBM Corporation and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.freescale.system.browser.epl;

import com.freescale.system.browser.epl.ITabbedPageEpl;

/**
 * Interface for a workbench/non-workbench part to contribute content to the tabbed view.
 * <p>
 * It is expected that the contributor ID is unique for a configuration of tabs
 * and sections. A configuration could be shared by sharing a
 * contributor ID. Tabs and sections cannot be shared from/across
 * multiple contributors.
 * </p>
 * <p>
 * As a workaround, if more elements implement
 * ITabbedPageContributor and they all return the same unique
 * contributor ID, then that configuration of tabs and sections will be used by
 * the tabbed view for that selection.
 * </p>
 */
public interface ITabbedPageContributorEpl {

	/**
	 * Returns the contributor ID for the tabbed page.
	 * 
	 * @return the contributor ID for the tabbed page.
	 */
	public String getContributorId();
	
	/**
	 * Returns the tabbed page it contributes to the System Browser View
	 * 
	 * @return the tabbed page it contributes
	 */
	public ITabbedPageEpl getTabbedSheetPage();
}
