/*******************************************************************************
 Copyright 2023 NXP 

 NXP Confidential and Proprietary. This software is owned or controlled by NXP
 and may only be used strictly in accordance with the applicable license terms.
 By expressly accepting such terms or by downloading, installing, activating
 and/or otherwise using the software, you are agreeing that you have read, and
 that you agree to comply with and are bound by, such license terms. If you do
 not agree to be bound by the applicable license terms, then you may not retain,
 install, activate or otherwise use the software.
 *******************************************************************************/

package com.freescale.system.browser.epl;

import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.part.IPageBookViewPage;
import com.freescale.system.browser2.OSAwarenessData2;


/**
 * Interface any tabbed page must implement. 
 */
public interface ITabbedPageEpl extends IPageBookViewPage, ISelectionListener {

	/**
	 * Get the instance of the contributor that owns this page (contributes 
	 * this page to the System Browser).
	 *
	 * @return - the owner of the page, the contributor that implements the
	 *         extension points and provides the page to the System Browser View
	 */
	public ITabbedPageContributorEpl getContributor();
	
	/**
	 * Called when the active context for the System Browser changes. That's
	 * the active debug context (the selection in the Debug view)
	 * 
	 * @param newSession the active debug context
	 */
	public void setPageInput(OSAwarenessData2 newSession);
}
