/*******************************************************************************
 Copyright 2023 NXP 

 NXP Confidential and Proprietary. This software is owned or controlled by NXP
 and may only be used strictly in accordance with the applicable license terms.
 By expressly accepting such terms or by downloading, installing, activating
 and/or otherwise using the software, you are agreeing that you have read, and
 that you agree to comply with and are bound by, such license terms. If you do
 not agree to be bound by the applicable license terms, then you may not retain,
 install, activate or otherwise use the software.
 *******************************************************************************/

package com.freescale.system.browser.epl.help;

import org.eclipse.jface.viewers.IFilter;

import com.freescale.system.browser.epl.ISectionDescriptorEpl;
import com.freescale.system.browser.epl.ISectionEpl;

/**
 * 
 * */
public interface ICustomSectionDescriptorEpl extends ISectionDescriptorEpl{

	/**
	 * Get the section filter instance for this section. Return null if no
	 * filter for this section.
	 * 
	 * @return the section filter instance.
	 */
	public IFilter getFilter();
	
	/**
	 * Get the class that implements this section.
	 * 
	 * @return the class that implements this section.
	 */
	public ISectionEpl getSection();
	
	/**
	 * Get the section identifier below which this section is displayed. <code>"top"</code>
	 * is returned if this section is the top most section or if there is one
	 * section in the tab.
	 * 
	 * @return the section identifier.
	 */
	public String getAfterSection();
	
}
