/*******************************************************************************
 * Copyright (c) 2006-2008 VecTrace (Zingo Andersen) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VecTrace (Zingo Andersen) - implementation
 *     Software Balm Consulting Inc (Peter Hunnisett <peter_hge at softwarebalm dot com>) - some updates
 *     StefanC                   - large contribution
 *     Jerome Negre              - fixing folders' state
 *******************************************************************************/
package com.freescale.system.browser.epl.help;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

import com.freescale.system.browser.epl.help.TasksTabDescriptorEpl.Column;
import com.freescale.system.browser2.TasksTreeContentProvider2.ProcessElement;
import com.freescale.system.browser2.TasksTreeContentProvider2.ThreadElement;
import com.freescale.system.browser2.ThreadInfo2;
import com.freescale.system.browser2.SystemBrowserActivator2;

/**
 * The label provider for the built-in Tasks table.
 *
 */
public class TasksTreeLabelProviderEpl implements ITableLabelProvider {

	/**
	 * The collection of columns (descriptors) in the table
	 */
	private Column[] fColumns;

	/**
	 * Indicates whether the built-in ID column should show hex values instead
	 * of decimal.
	 */
	private boolean fShowIdAsHex;

	/**
	 * Constructor
	 * 
	 * @param columns
	 *            The collection of columns (descriptors) in the table
	 */
	public TasksTreeLabelProviderEpl(Column[] columns, boolean showIdAsHex) {
		fColumns = columns.clone();
		fShowIdAsHex = showIdAsHex;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.
	 * Object, int)
	 */
	@Override
	public Image getColumnImage(Object element, int columnIndex) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.
	 * Object, int)
	 */
	@Override
	public String getColumnText(Object element, int columnIndex) {
		if (columnIndex < fColumns.length) {
			Column col = fColumns[columnIndex];
			if (element instanceof ProcessElement) {
				if (col.dataId.equals(TasksTabDescriptorEpl.BUILTIN_COLUMN_DATAID_NAME)) {
					return ((ProcessElement) element).processInfo.name;
				} else if (col.dataId.equals(TasksTabDescriptorEpl.BUILTIN_COLUMN_DATAID_ID)) {
					return Long.toString(((ProcessElement) element).processInfo.processId);
				}

			} else if (element instanceof ThreadElement) {
				ThreadInfo2 tinfo = ((ThreadElement) element).threadInfo;
				if (col.builtIn) {
					if (col.dataId.equals(TasksTabDescriptorEpl.BUILTIN_COLUMN_DATAID_NAME)) {
						return tinfo.getName();
					} else if (col.dataId.equals(TasksTabDescriptorEpl.BUILTIN_COLUMN_DATAID_ID)) {
						return fShowIdAsHex ? ("0x" + Long.toString(tinfo.getThreadId(), 16)) : Long.toString(tinfo.getThreadId()); //$NON-NLS-1$
					} else if (col.dataId.equals(TasksTabDescriptorEpl.BUILTIN_COLUMN_DATAID_STATUS)) {
						return tinfo.getState();
					} else {
						SystemBrowserActivator2.log(IStatus.ERROR, "internal error; unexpected column"); //$NON-NLS-1$
					}
				} else {
					final String property = tinfo.getExtendedInfo(col.dataId);
					if (property != null) {
						return property;
					}

				}
			}
		}
		return ""; //$NON-NLS-1$
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.jface.viewers.IBaseLabelProvider#addListener(org.eclipse.
	 * jface.viewers.ILabelProviderListener)
	 */
	@Override
	public void addListener(ILabelProviderListener listener) {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
	 */
	@Override
	public void dispose() {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(java.lang.
	 * Object, java.lang.String)
	 */
	@Override
	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(org.eclipse.
	 * jface.viewers.ILabelProviderListener)
	 */
	@Override
	public void removeListener(ILabelProviderListener listener) {
	}
}
