/*******************************************************************************
Copyright 2023 NXP 

 NXP Confidential and Proprietary. This software is owned or controlled by NXP
 and may only be used strictly in accordance with the applicable license terms.
 By expressly accepting such terms or by downloading, installing, activating
 and/or otherwise using the software, you are agreeing that you have read, and
 that you agree to comply with and are bound by, such license terms. If you do
 not agree to be bound by the applicable license terms, then you may not retain,
 install, activate or otherwise use the software.
 *******************************************************************************/

package com.freescale.s32ds.ext.cdt.utils.epl.help;

import java.util.stream.Stream;
import org.eclipse.core.runtime.Platform;
import com.freescale.s32ds.ext.cdt.utils.epl.EclipseUtilsEpl;

public enum OSFamilyEpl {

	WINDOWS("windows", osStartsWith("win")), 
	LINUX("linux", osStartsWith(Platform.OS_LINUX)), 
	OSX("osx", osStartsWith("mac")),
	OTHER("other", false);

	public static final OSFamilyEpl current = Stream.of(values()).filter(f -> f.isCurrent).findAny().orElse(OTHER);
	public final String family; 
	private final boolean isCurrent;
	
	private OSFamilyEpl(String family, boolean isCurrent) {
		this.family = family;
		this.isCurrent = isCurrent;
	}
	
	public boolean isCurrent() {
		return equals(current);
	}
	
	private static boolean osStartsWith(String prefix) {
		return System.getProperty(EclipseUtilsEpl.PROPERTY_OS_NAME).toLowerCase().startsWith(prefix);
	}
	
}
