/**
* Copyright 2019, 2023 NXP
*
* SPDX-License-Identifier: EPL-1.0

*/
 package com.nxp.s32ds.ext.rcp.utils.epl.viewers;

import org.eclipse.jface.viewers.ICheckStateProvider;

/**
 * Class is used in {@link ContainerFilteredCheckboxTreeViewer}.
 *
 */
public class TreeContentCheckStateProvider implements ICheckStateProvider {

	private final TreeContentCheckStateHolder stateHolder;

	public TreeContentCheckStateProvider(TreeContentCheckStateHolder stateHolder) {
		this.stateHolder = stateHolder;
	}

	@Override
	public boolean isChecked(Object element) {
		// we should set checked if grayed is true
		return stateHolder.isChecked(element) || isGrayed(element);
	}

	@Override
	public boolean isGrayed(Object element) {
		return !stateHolder.isChecked(element) && stateHolder.isChildChecked(element);
	}
}