/**
 * Copyright 2019 NXP
 * Created:  Jan 24, 2019
 */
package com.nxp.swtools.derivative.rcp;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Item;


/**
 * Interface to provide color for column header
 * @author Marek Trmac, marek.trmac@nxp.com
 */
public interface IHeaderColumnColorProvider {

	/**
	 * Return background color for the column
	 * @param column selected column
	 * @return background cell color; <code>null</code> to use default
	 */
	Color getBackgroundColor(Item column);

	/**
	 * Return foreground color for the column
	 * @param column selected column
	 * @return foreground cell color; <code>null</code> to use default
	 */
	default Color getForegroundColor(@SuppressWarnings("unused") Item column) {
		return null;
	}

}
